<?php
header('Content-Type: application/json');

$lat = floatval($_GET['lat'] ?? -25.4289541);
$lon = floatval($_GET['lon'] ?? -49.267137);
$radius = 30000;

// Função para calcular distância Haversine
function haversine($lat1, $lon1, $lat2, $lon2) {
    $R = 6371000; // metros
    $dLat = deg2rad($lat2 - $lat1);
    $dLon = deg2rad($lon2 - $lon1);
    $a = sin($dLat / 2) ** 2 + cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * sin($dLon / 2) ** 2;
    return $R * (2 * atan2(sqrt($a), sqrt(1 - $a)));
}

// Consulta Overpass para moteis e restaurantes
$query = <<<QUERY
[out:json][timeout:25];
(
  node["name"~"otel", i](around:$radius,$lat,$lon);
  node["tourism"="hotel"](around:$radius,$lat,$lon);
  node["amenity"="restaurant"](around:$radius,$lat,$lon);
);
out;
QUERY;

$url = "https://overpass-api.de/api/interpreter";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, "data=" . $query);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
$response = curl_exec($ch);

if (curl_errno($ch)) {
    echo json_encode(['erro' => 'Erro cURL', 'detalhe' => curl_error($ch)]);
    curl_close($ch);
    exit;
}
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode !== 200) {
    echo json_encode(['erro' => 'Falha na requisição', 'http_code' => $httpCode, 'resposta' => $response]);
    exit;
}

$data = json_decode($response, true);
$moteis = [];
$restaurantes = [];

if (!empty($data['elements'])) {
    foreach ($data['elements'] as $el) {
        $nome = $el['tags']['name'] ?? '';
        $lat2 = $el['lat'] ?? ($el['center']['lat'] ?? null);
        $lon2 = $el['lon'] ?? ($el['center']['lon'] ?? null);

        if (!$lat2 || !$lon2 || !$nome) continue;

        $distancia = haversine($lat, $lon, $lat2, $lon2);

        if (stripos($nome, 'motel') !== false) {
            $moteis[] = [
                'tipo' => 'motel',
                'nome' => $nome,
                'latitude' => $lat2,
                'longitude' => $lon2,
                'distancia_metros' => round($distancia)
            ];
        } elseif (($el['tags']['amenity'] ?? '') === 'restaurant') {
            $restaurantes[] = [
                'tipo' => 'restaurante',
                'nome' => $nome,
                'latitude' => $lat2,
                'longitude' => $lon2,
                'distancia_metros' => round($distancia)
            ];
        }
    }
}

// Ordena e limita
usort($moteis, fn($a, $b) => $a['distancia_metros'] <=> $b['distancia_metros']);
usort($restaurantes, fn($a, $b) => $a['distancia_metros'] <=> $b['distancia_metros']);

$moteis = array_slice($moteis, 0, 2);
$restaurantes = array_slice($restaurantes, 0, 2);

$resultado = [];
$max = max(count($moteis), count($restaurantes));

for ($i = 0; $i < $max; $i++) {
    if (isset($moteis[$i])) $resultado[] = $moteis[$i];
    if (isset($restaurantes[$i])) $resultado[] = $restaurantes[$i];
}

echo json_encode($resultado);