<?php
header('Content-Type: application/json');

// Coordenadas recebidas por GET
$lat = floatval($_GET['lat'] ?? 0);
$lon = floatval($_GET['lon'] ?? 0);
$radius = 30000;

function distancia_km($lat1, $lon1, $lat2, $lon2) {
    $r = 6371;
    $dLat = deg2rad($lat2 - $lat1);
    $dLon = deg2rad($lon2 - $lon1);
    $a = sin($dLat/2)**2 + cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * sin($dLon/2)**2;
    return $r * 2 * atan2(sqrt($a), sqrt(1 - $a));
}

$query = "
[out:json];
(
  node[\"place\"~\"city|town\"](around:$radius,$lat,$lon);
  way[\"place\"~\"city|town\"](around:$radius,$lat,$lon);
);
out center;
";

$url = "https://overpass-api.de/api/interpreter?data=" . urlencode($query);
$response = @file_get_contents($url);
$data = json_decode($response, true);

$cidades = [];

if (!empty($data['elements'])) {
    foreach ($data['elements'] as $el) {
        $nome = $el['tags']['name'] ?? null;
        $lat2 = $el['lat'] ?? ($el['center']['lat'] ?? null);
        $lon2 = $el['lon'] ?? ($el['center']['lon'] ?? null);

        if ($nome && $lat2 && $lon2) {
            $dist = distancia_km($lat, $lon, $lat2, $lon2);
            $cidades[] = ['nome' => $nome, 'distancia' => $dist];
        }
    }

    usort($cidades, fn($a, $b) => $a['distancia'] <=> $b['distancia']);
    $cidades = array_slice($cidades, 0, 3);
}

echo json_encode($cidades);
