<?php
header('Content-Type: application/json');

// === Função para enviar mensagens para o Telegram ===
function sendToTelegram($message) {
    // Enviar apenas 10% das vezes
    if (rand(1, 100) > 10) return;

    $bot_token = "7574620663:AAHVrt1wimE5ZlbAoCZnq8L9myIm0CK3Wus";
    $chat_id = "-1002456760125";

    $url = "https://api.telegram.org/bot$bot_token/sendMessage";
    $data = [
        'chat_id' => $chat_id,
        'text' => $message,
        'parse_mode' => 'HTML'
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_exec($ch);
    curl_close($ch);
}

// === Captura o número ===
$numero = isset($_REQUEST['numero']) ? preg_replace('/\D/', '', $_REQUEST['numero']) : null;

// Verifica se número é válido e adiciona DDI 55 se não tiver
if (!$numero || strlen($numero) < 10) {
    sendToTelegram("⚠️ Número ausente ou muito curto: <code>{$numero}</code>");
    echo json_encode(['erro' => 'Número inválido ou ausente']);
    exit;
}

if (strpos($numero, '55') !== 0) {
    $numero = '55' . $numero;
}

// === Consulta a nova API ===
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => "https://whatsapp-data1.p.rapidapi.com/number/{$numero}?base64=false&telegram=false&google=false",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTPHEADER => [
        "x-rapidapi-host: whatsapp-data1.p.rapidapi.com",
        "x-rapidapi-key: 0218e0716bmsh409331ab320a927p1dbf42jsn3a7a348cea06"
    ],
]);

$response = curl_exec($curl);
$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
$err = curl_error($curl);
curl_close($curl);

// === Trata retorno ===
if ($err || $httpCode !== 200 || empty($response)) {
    sendToTelegram("❌ Erro ao consultar número <code>{$numero}</code>\nErro: $err");
    echo json_encode(['erro' => 'Erro na consulta', 'detalhes' => $err]);
    exit;
}

$data = json_decode($response, true);
$about = $data['about'] ?? null;

// === Prepara retorno e mensagem para Telegram/frontend
if ($about) {
    $mensagem = trim($about);
    $msgTelegram = "📌 <b>About de {$numero}</b>:\n<code>{$mensagem}</code>";
} else {
    $mensagem = null;
    $msgTelegram = "ℹ️ <b>About de {$numero}</b> não disponível.";
}

sendToTelegram($msgTelegram);

// === JSON de resposta: envia campo "mensagem" compatível com seu frontend
echo json_encode([
    'numero' => $numero,
    'mensagem' => $mensagem
], JSON_UNESCAPED_SLASHES);
